#!/bin/bash
#SBATCH --mem=8G
#SBATCH --cpus-per-task=5
#SBATCH --time=3:00:00
#SBATCH --output=/scratch/shared/beegfs/yuki/slurm/places365-pass-%a.out
#SBATCH --open-mode=A
#SBATCH --partition=compute
#SBATCH --constraint=ib_hdr100
#SBATCH --job-name=places
#SBATCH --array=0-50

cd /users/yuki/adiwol/experts/places365

echo $SLURM_ARRAY_TASK_ID
X=$((${SLURM_ARRAY_TASK_ID}*26000))
Y=$(((${SLURM_ARRAY_TASK_ID} + 1)*26000))

in_file=_split_pass_${SLURM_ARRAY_TASK_ID}.txt
rm ${in_file}
results_dir='/scratch/shared/beegfs/yuki/data/fast/split_pass/places365-r50/'
mkdir -p ${results_dir}

< /scratch/shared/beegfs/yuki/data/split_user_stratified.txt tail -n +"$X" | head -n "$((Y - X))" >> ${in_file}

/scratch/shared/beegfs/yuki/envs/py37/bin/python main_places365.py \
                                                  --input_txt=${in_file} \
                                                  --save_folder=${results_dir} \
                                                  --arch resnet50 \
                                                  --split $SLURM_ARRAY_TASK_ID \
                                                  --cpu